<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require 'vendor/autoload.php'; // Ensure you have installed google/apiclient via Composer

use Google\Client;
use Google\Service\FirebaseCloudMessaging;

define('FIREBASE_PROJECT_ID', 'insugo-digi'); // Replace with your Firebase project ID
define('SERVICE_ACCOUNT_JSON', 'insugo-digi-firebase-adminsdk-ckcgs-8e42d1269f.json'); // Path to your service account JSON file

// Function to send push notification via FCM v1 API
function sendPushNotification($deviceToken, $title, $body) {
    // Initialize Google Client and authenticate using the service account
    $client = new Client();
    $client->setAuthConfig(SERVICE_ACCOUNT_JSON);
    $client->addScope('https://www.googleapis.com/auth/firebase.messaging');

    // Get an access token
    $accessToken = $client->fetchAccessTokenWithAssertion()['access_token'];

    // Set up the HTTP request data for the notification
    $url = "https://fcm.googleapis.com/v1/projects/" . FIREBASE_PROJECT_ID . "/messages:send";
    $postData = [
        'message' => [
            'token' => $deviceToken,
            'notification' => [
                'title' => $title,
                'body' => $body,
            ]
        ]
    ];

    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json',
    ]);

    // Execute cURL request
    $response = curl_exec($ch);
    if ($response === FALSE) {
        die('Error: ' . curl_error($ch));
    }

    curl_close($ch);
    return $response;
}

// Example usage
$deviceToken = 'esy6sxbLRS64zJi-A8XlOp:APA91bGY6zO6Il-wcegMYTI2sPEFvSpfwznX9zFKIlJbDpgWD_ZXEjU3UVdtqM-7kkgOc2FrR0AQAoB0DCdcfEkaPNGJjB9UJOLr8imCRuaV-wIDwKrWhHs'; // Replace with the actual device token
$title = "Test Notification";
$body = "This is a test notification sent via FCM HTTP v1 API.";

$response = sendPushNotification($deviceToken, $title, $body);
echo "Response: " . $response;
?>
